<?php
header("Content-Type: application/json");

// Manually create MySQL connection
$servername = "localhost"; // ya aapka host name
$username = "rajagame_bdgwin";
$password = "rajagame_bdgwin";
$database = "rajagame_bdgwin";

// Create connection
$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["status" => false, "message" => "Connection failed: " . $conn->connect_error]);
    exit;
}

$order_id = $_POST['mch_order_no'];
$amount = $_POST['sucOrderAmount'];

// Get UID based on order_id
$uidQuery = $conn->prepare("SELECT balakedara FROM `thevani` WHERE dharavahi = ?");
$uidQuery->bind_param("s", $order_id);
$uidQuery->execute();
$uidQuery->bind_result($uid);
$uidQuery->fetch();
$uidQuery->close();

if (!$uid) {
    echo json_encode(["status" => false, "message" => "Order not found"]);
    exit;
}

// Update payment status in `thevani`
$updatePayment = $conn->prepare("UPDATE `thevani` SET sthiti = '1' WHERE dharavahi = ?");
$updatePayment->bind_param("s", $order_id);
$updatePayment->execute();
$updatePayment->close();

// Add money to user's balance
$updateBalance = $conn->prepare("UPDATE `shonu_kaichila` SET motta = motta + ? WHERE balakedara = ?");
$updateBalance->bind_param("ds", $amount, $uid);
$updateBalance->execute();
$updateBalance->close();

echo json_encode(["status" => true, "message" => "Payment successful, balance updated"]);

// Close connection
$conn->close();
?>
