<?php 
	include "../../conn.php";
	include "../../functions2.php";
	
	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');
	
	date_default_timezone_set("Asia/Kolkata");
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);
	
	if ($_SERVER['REQUEST_METHOD'] != 'GET') {
		if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp']) && isset($shonupost['withdrawid'])) {
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$withdrawid = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['withdrawid']));
			$shonustr = '{"language":'.$language.',"random":"'.$random.'","withdrawid":'.$withdrawid.'}';
			$shonusign = strtoupper(md5($shonustr));
			if($shonusign == $signature){
				$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
				$author = $bearer[1];				
				$is_jwt_valid = is_jwt_valid($author);
				$data_auth = json_decode($is_jwt_valid, 1);
				if($data_auth['status'] === 'Success') {
					$sesquery = "SELECT akshinak
					  FROM shonu_subjects
					  WHERE akshinak = '$author'";
					$sesresult=$conn->query($sesquery);
					$sesnum = mysqli_num_rows($sesresult);
					if($sesnum == 1){
						http_response_code(200);
						if($withdrawid == 1){
							echo '
								{
								  "data": {
									"banklist": [
									  {
										"bankID": 16,
										"bankLogo": "https://www.africa2trust.com/wba/Logos/BOB319172330.png",
										"bankName": "Bank of Baroda",
										"reserved": "1"
									  },
									  {
										"bankID": 15,
										"bankLogo": "https://companieslogo.com/img/orig/UNIONBANK.NS-5bba728d.png?t=1720244494",
										"bankName": "Union Bank of India",
										"reserved": "1"
									  },
									  {
										"bankID": 14,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRL4eQAv8YVZQJnFAtnxqs-zoMtsJryohcScg&s",
										"bankName": "Central Bank of India",
										"reserved": "1"
									  },
									  {
										"bankID": 13,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ7hIU7hKVcm98kSsxw_qhXR6-Xx2Wi-BSXAw&s",
										"bankName": "Yes Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 12,
										"bankLogo": "https://assets.upstox.com/content/assets/images/cms/2024419/HDFC-Bank-emblem.png",
										"bankName": "HDFC Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 11,
										"bankLogo": "https://yt3.googleusercontent.com/ytc/AIdro_nxjOPJqzxIpRFze0P1q9uBrzw6Cy3-6BfSynl7ZC59lw=s900-c-k-c0x00ffffff-no-rj",
										"bankName": "Karnataka Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 10,
										"bankLogo": "https://play-lh.googleusercontent.com/pFLqpSYG_dP2lWU8UFUHjDt5M7aMNXvR_4WcP20C_W07kknA4WsF2rRsGJH2HlqGyP69",
										"bankName": "Standard Chartered Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 9,
										"bankLogo": "https://assets.bizclikmedia.net/576/dc1f90d927bc25a76d156ae1d0f26603:d529edeaf3ca5dc1c2ff84f4df084a47/idbi-bank-600.png",
										"bankName": "IDBI Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 8,
										"bankLogo": "https://images.indianexpress.com/2022/02/bank-of-india-boi-facebook.jpg",
										"bankName": "Bank of India",
										"reserved": "1"
									  },
									  {
										"bankID": 7,
										"bankLogo": "https://eu-images.contentstack.com/v3/assets/blt7dacf616844cf077/bltc3923a829e585139/679906d957765273cee99b80/Punjab-National-Bank-logo.jpg",
										"bankName": "Punjab National Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 6,
										"bankLogo": "https://play-lh.googleusercontent.com/3k0f2yWl15mhkyltVQoqwmfRcm6ywTDYOttNHusElScrqjxYHLK82oVnjt3wQJQyPw",
										"bankName": "ICICI Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 5,
										"bankLogo": "https://crystalpng.com/wp-content/uploads/2025/11/Canara-Bank-Logo.png",
										"bankName": "Canara Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 4,
										"bankLogo": "https://s3-symbol-logo.tradingview.com/kotak-mahindra-bank--600.png",
										"bankName": "Kotak Mahindra Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 3,
										"bankLogo": "https://ismg-cdn.nyc3.cdn.digitaloceanspaces.com/articles/sbi-investigates-reported-massive-data-leak-showcase_image-2-a-11986.jpg",
										"bankName": "State Bank of India",
										"reserved": "1"
									  },
									  {
										"bankID": 2,
										"bankLogo": "https://images.financialexpressdigital.com/2025/05/Indian-bank.X.jpg",
										"bankName": "Indian Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 1,
										"bankLogo": "https://www.samco.in/knowledge-center/wp-content/uploads/2025/04/Axis-Bank-Q4FY25-Results-What-to-Expect-Before-April-24.jpg",
										"bankName": "Axis Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 17,
										"bankLogo": "https://s3-symbol-logo.tradingview.com/fed-bank--600.png",
										"bankName": "FEDERAL BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 18,
										"bankLogo": "https://content3.jdmagicbox.com/v2/comp/bangalore/30/080p5002230/catalogue/syndicate-bank-nandhini-layout-bangalore-banks-3l0024p.jpg",
										"bankName": "Syndicate Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 22,
										"bankLogo": "https://upload.wikimedia.org/wikipedia/commons/thumb/7/73/Citi_logo_March_2023.svg/1200px-Citi_logo_March_2023.svg.png",
										"bankName": "Citibank India",
										"reserved": "1"
									  },
									  {
										"bankID": 23,
										"bankLogo": "https://content.jdmagicbox.com/v2/comp/chennai/p9/044pxx44.xx44.171219221440.e8p9/catalogue/indian-overseas-bank-senneerkuppam-chennai-nationalised-banks-0qtwjg7lif.jpg",
										"bankName": "Indian Overseas Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 24,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRsSe-HMeDDrBcQrzq_uEdnSSBj7jS7UPbiKQ&s",
										"bankName": "IDFC Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 25,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRWBumMRTPYanZLsg8qrYq8SZILsqPuIq8RvQ&s",
										"bankName": "Bandhan Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 26,
										"bankLogo": "https://media.licdn.com/dms/image/v2/D4D12AQESboIyp1y40A/article-cover_image-shrink_720_1280/B4DZXbgQhSHAAI-/0/1743144422537?e=2147483647&v=beta&t=FzXuXCEZzMWDUGXrITXAnR0Zj1p6FXlTwimZZ59EsKA",
										"bankName": "Indusind Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 29,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSKb_fXCVvzVytAGVB2TXzD6jMB1DPKEWroiQ&s",
										"bankName": "Equitas Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 30,
										"bankLogo": "https://yt3.googleusercontent.com/ytc/AIdro_nRVhyRPd_nPCENZyPpu_ji6HK24aqEkRwxit6aaAVLnIE=s900-c-k-c0x00ffffff-no-rj",
										"bankName": "India Post Payments Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 31,
										"bankLogo": "https://planify-main.s3.amazonaws.com/media/images/documents/Corporationbankjpg-1589539757049.webp",
										"bankName": "Corporation Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 27,
										"bankLogo": "https://www.eqimg.com/images/2024/10282024-image3-thumb-equitymaster.jpg",
										"bankName": "Jammu & Kashmir Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 32,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTdU_yays5OTHLuKGNdqZBLwB5e3oiw_DgaiCWKnQ5ul2TIKWj3WOt8MXgr5681I5h376Q&usqp=CAU",
										"bankName": "City Union Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 28,
										"bankLogo": "https://etimg.etb2bimg.com/thumb/msid-107958388,width-1200,height-900,resizemode-4/.jpg",
										"bankName": "PYTM PAYMENTS BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 33,
										"bankLogo": "https://play-lh.googleusercontent.com/aG2nPkzRR_nfxXnema47yxWwBapSB913EbNT14-1GtIA3pF5FzwEt_Hg4mbHskT-ioY=s256-rw",
										"bankName": "Karur Vysya Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 34,
										"bankLogo": "https://d2un9pqbzgw43g.cloudfront.net/main/Tamilnad-Mercantile-Bank.png",
										"bankName": "Tamilnad Mercantile Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 35,
										"bankLogo": "https://bfsi.eletsonline.com/wp-content/uploads/2019/12/Allahabad-Bank.jpg",
										"bankName": "Allahabad Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 36,
										"bankLogo": "https://play-lh.googleusercontent.com/Ti6PR5xzylgW6kyUlrpmZoJizpWUAwAB5aYRz7_6xp9BDtlnFxbSYAQId9gjfcFSWJsc",
										"bankName": "varachha co-operative bank",
										"reserved": "1"
									  },
									  {
										"bankID": 37,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRDtt6QQZxrDydRoISs9Q03s26Tx0lgwWTekQ&s",
										"bankName": "Meghalaya Rural Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 38,
										"bankLogo": "https://yt3.googleusercontent.com/9G06gilu1qt2JWlmaGcogKeDfjjnwDOElx-jCPAK8nCSQeeiwbMZoZngEI1nVeons75yswoG-C4=s900-c-k-c0x00ffffff-no-rj",
										"bankName": "AU Small Finance Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 39,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSWhqfT_hfA81n56_U3gxURHUKoP3aJBbFngw&s",
										"bankName": "Lakshmi Vilas Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 40,
										"bankLogo": "https://etimg.etb2bimg.com/thumb/msid-117433373,width-1200,height-900,resizemode-4/.jpg",
										"bankName": "South Indian Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 41,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTCA5uF-FT9smeT5Zepm-iu7eS0typ0xTz3TA&s",
										"bankName": "Bassein catholic co-operative Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 42,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTvpOaMlYPlKJKRxPGhhZy-34rYR02HmCaLOQ&s",
										"bankName": "Airtel Payment Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 43,
										"bankLogo": "https://upload.wikimedia.org/wikipedia/commons/thumb/c/c5/State_Bank_of_Hyderabad_logo.svg/1200px-State_Bank_of_Hyderabad_logo.svg.png",
										"bankName": "State Bank of Hyderabad",
										"reserved": "1"
									  },
									  {
										"bankID": 44,
										"bankLogo": "https://play-lh.googleusercontent.com/Ik8RVDJUz9Eu0yavxCPVHXtws73VNwf4ClT0o2YxBr_uqHA8oSW_PgNyh_ndTseEI7A",
										"bankName": "Gp parsik bank",
										"reserved": "1"
									  },
									  {
										"bankID": 45,
										"bankLogo": "https://play-lh.googleusercontent.com/xlgfcJtSLL3mNLW2KKJXLsZvi8Ug6HtPvMM8C5MuHe80cYtBfxrIxjbDaOqQTCHMiRg",
										"bankName": "Kerala Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 46,
										"bankLogo": "https://play-lh.googleusercontent.com/V8Zlwk92MUcMQiLOdo_k28MiweE91XqeaF8gczs50-Eo45mu1fNLNA2_b6wE5HJKAt4",
										"bankName": "RBL Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 47,
										"bankLogo": "https://trendlyne-media-mumbai-new.s3.amazonaws.com/profilepicture/326_profilepicture.jpg",
										"bankName": "Dhanlaxmi Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 48,
										"bankLogo": "https://jobkola.com/img/logo/tjsb-bank.png",
										"bankName": "TJSB Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 49,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTeM3koj7gDghH7AJ0-XufJJyBDcA552qNoQA&s",
										"bankName": "Punjab & Sind Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 50,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSnShPuj23addZGmuusz-0aBAmPtcwhsgqV7A&s",
										"bankName": "Purvanchal bank",
										"reserved": "1"
									  },
									  {
										"bankID": 51,
										"bankLogo": "https://images.jdmagicbox.com/comp/ambala/m3/9999px171.x171.140316112603.q5m3/catalogue/sarva-haryana-gramin-bank-saha-ambala-banks-y55zxu5.jpg",
										"bankName": "Sarva Haryana Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 52,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRpT3BEIkI-Pilx5K8VhsC2jow8L3bPL2nKbw&s",
										"bankName": "Ahmedabad District Co-Operative Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 53,
										"bankLogo": "https://eu-images.contentstack.com/v3/assets/blt7dacf616844cf077/blt5ca807320a7f06e1/679914bf8b04f1819dcc466a/Fino-Payments-Bank.jpg",
										"bankName": "Fino Payments Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 54,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRcgmnlwCypZA6rp5O1LkIU08lUUBDA0GgqGA&s",
										"bankName": "Saraswat Cooperative Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 62,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C560BAQGLzKYlcLXu5g/company-logo_200_200/company-logo_200_200/0/1630644126974?e=2147483647&v=beta&t=z-XWmwEp_SwGx4mnRmJWFvSY-l6dp4nfBifH5wm1ItA",
										"bankName": "Dhanlaxmi bank",
										"reserved": "1"
									  },
									  {
										"bankID": 63,
										"bankLogo": "https://play-lh.googleusercontent.com/ECQRo1f3WU5ZHBV69OPU-L_LY87Q52k1rUbPb8-2RW1l1p7KIQzWuZmBZN_1vVXFGx1b",
										"bankName": "Telangana Grameena Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 57,
										"bankLogo": "https://play-lh.googleusercontent.com/vrfG2U2ocDaZbju3QgeevoO1VeFgRUOnqaA82aMRRaCGqYdEk6qkpOqkujwAkiupenU",
										"bankName": "andhra pragathi grameena bank",
										"reserved": "1"
									  },
									  {
										"bankID": 58,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRXiXHkPdIpelshlhnVlpZ1xixig4GTXjLUVQ&s",
										"bankName": "rajasthan marudhara gramin bank",
										"reserved": "1"
									  },
									  {
										"bankID": 59,
										"bankLogo": "https://play-lh.googleusercontent.com/uoc7m4EK68k5gdBMukSP96zCFz2vrkTKxftF1thq25A7ZHXmRouzPdT7yvRUJmf9Tcft=w240-h480-rw",
										"bankName": "Abhyudaya bank",
										"reserved": "1"
									  },
									  {
										"bankID": 60,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRAE84jw57OfFiHLGZ5lDs4X-dg-yDmL-PwQw&s",
										"bankName": "ujjivan small finance bank",
										"reserved": "1"
									  },
									  {
										"bankID": 61,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C510BAQER7RvhLIiISQ/company-logo_200_200/company-logo_200_200/0/1630614274833/pkgbank_logo?e=2147483647&v=beta&t=rjwvWdrzrguJcF0ubNE3qVoQH1xtUmu1v7dplnVI5D0",
										"bankName": "Pragathi Krishna Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 64,
										"bankLogo": "https://www.unlistedsharebrokers.com/wp-content/uploads/2018/12/Capital-Small-Finance-Bank-logo.jpg",
										"bankName": "capital small finance bank",
										"reserved": "1"
									  },
									  {
										"bankID": 65,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQAoYqRs7nVNUmf6MdbiDbmMU0d9iOCT37kpQ&s",
										"bankName": "Mizoram Rural Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 66,
										"bankLogo": "https://media.licdn.com/dms/image/v2/D560BAQFHsNvVNK6QHA/company-logo_200_200/company-logo_200_200/0/1682484505351?e=2147483647&v=beta&t=In5ipurHOf9Q4qtlq6dJGw0CQwt1ko0-VVwmp4zSusY",
										"bankName": "Andhra Pradesh Grameena Vikas Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 67,
										"bankLogo": "https://media.licdn.com/dms/image/v2/D560BAQEuBXz3GS-6Ng/company-logo_200_200/company-logo_200_200/0/1709990009464/karnataka_vikas_grameena_bank_logo?e=2147483647&v=beta&t=8xPWQH37DKg0EhgYOeRe1BfF7uWbLxkON07VE1WAiS4",
										"bankName": "Karnataka Vikas Grameena Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 68,
										"bankLogo": "https://play-lh.googleusercontent.com/FbYnVKeuOhFjcoh52WRIhw2Nb2Q7zynpAKtA1cMdW4YfyDmjJ1Qj4FHHrA8zFefOutw=w240-h480-rw",
										"bankName": "The Ahmedabad merchantile co-op bank Ltd",
										"reserved": "1"
									  },
									  {
										"bankID": 69,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT3aIWBYdoT5erf-AIX6gaNY9WNvK7c1cqQXw&s",
										"bankName": "Madhya Bihar Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 70,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTqWWYaqJygb2Bb66tniTqnondMYvY5dJOM-Q&s",
										"bankName": "NSDL Payments Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 71,
										"bankLogo": "https://bfsi.eletsonline.com/wp-content/uploads/2017/04/esaf-small-finance-bank.jpg",
										"bankName": "ESAF Small Finance Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 72,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQFGjvV-_k0G2gXPowek_jVT2ODI1T6_eQtHg&s",
										"bankName": "Himachal Pradesh state cooperative bank",
										"reserved": "1"
									  },
									  {
										"bankID": 73,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTLsLajIE29HWgqO4hd330qhVBKQLy2rJ0ogA&s",
										"bankName": "Maharashtra state cooperative bank",
										"reserved": "1"
									  },
									  {
										"bankID": 74,
										"bankLogo": "https://bsmedia.business-standard.com/_media/bs/img/article/2016-02/11/full/1455184458-0879.jpg",
										"bankName": "ORIENTAL BANK OF COMMERCE",
										"reserved": "1"
									  },
									  {
										"bankID": 75,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTNB5YOe3HYA_IQqkkSqdYjYc60BRpnH2KdRw&s",
										"bankName": "nainital bank",
										"reserved": "1"
									  },
									  {
										"bankID": 76,
										"bankLogo": "https://play-lh.googleusercontent.com/ECQRo1f3WU5ZHBV69OPU-L_LY87Q52k1rUbPb8-2RW1l1p7KIQzWuZmBZN_1vVXFGx1b=w600-h300-pc0xffffff-pd",
										"bankName": "Telangana grameena bank",
										"reserved": "1"
									  },
									  {
										"bankID": 77,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTdhiV8bC4rHQw7Y8w4oP6ewMNiOrv4J9ZblQ&s",
										"bankName": "Jharkhand Rajya Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 78,
										"bankLogo": "https://www.equitybulls.com/equitybullsadmin/uploads/Jio%20Payments%20Bank%20Limited%204.jpg",
										"bankName": "jio payments bank",
										"reserved": "1"
									  },
									  {
										"bankID": 79,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSqnzARb8BiY7fh0EM63YXNqF7JqXrlac61dg&s",
										"bankName": "MAHARASHTRA GRAMIN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 81,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQeCEjAgxS1mZpi1JDLE-CD6QGtEDl9EU6ZeA&s",
										"bankName": "Uttarakhand Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 82,
										"bankLogo": "https://cdn.prod.website-files.com/64199d190fc7afa82666d89c/6491bec8db5a896d1fb786ef_dbs-bank.webp",
										"bankName": "DBS BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 83,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSKb_fXCVvzVytAGVB2TXzD6jMB1DPKEWroiQ&s",
										"bankName": "Equitas Small Finance Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 84,
										"bankLogo": "https://play-lh.googleusercontent.com/X7p26HepXjfjG8XX2NpaIV1RqtKh620CBMMoE7KrqS8Nu3RmbDIY5VHs4-fL5HZtZTk",
										"bankName": "Himachal Pradesh Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 85,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRWrWdX5Y-JfKZxVdS9HbbDLScOV3uaaBAM-w&s",
										"bankName": "Krishna District Co-Operative Central Bank Ltd.",
										"reserved": "1"
									  },
									  {
										"bankID": 86,
										"bankLogo": "https://play-lh.googleusercontent.com/NYldASW0QivHK9kMRpd9CfBT7jbUBtnkLNrqcRLNLH9jS6Qx7wIS0ntsw9bFmvY9pgw",
										"bankName": "RAJKOT NAGARIK SAHAKARI BANK LTD",
										"reserved": "1"
									  },
									  {
										"bankID": 87,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQMuutzqPIOcTnR-zYspXyp5-JPHF2KRbDk2Q&s",
										"bankName": "North East small financial bank",
										"reserved": "1"
									  },
									  {
										"bankID": 88,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQfTDjvp1NRnqOATV0Ybs3s4LBYzAkaXSmdLQ&s",
										"bankName": "Catholic syrian bank",
										"reserved": "1"
									  },
									  {
										"bankID": 89,
										"bankLogo": "https://play-lh.googleusercontent.com/iWNhl42H4JZY4cjVqMYrQnjwYqavTy7YALDbcLhiL1d_oOAdoAnV8gKWgeFlatHkGUg",
										"bankName": "Fincare small finance bank",
										"reserved": "1"
									  },
									  {
										"bankID": 90,
										"bankLogo": "https://static.wikia.nocookie.net/logopedia/images/c/c2/BUPGB.jpeg/revision/latest?cb=20200407105241",
										"bankName": "Baroda Uttar Pradesh Gramin Bank",
										"reserved": "1"
									  },
									 
									  {
										"bankID": 92,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTQr8E5q2DY5gFk2mHHqVQ-ayISwku4uDCOAg&s",
										"bankName": "Cosmos Co-operative Bank Ltd",
										"reserved": "1"
									  },
									  {
										"bankID": 93,
										"bankLogo": "https://content3.jdmagicbox.com/v2/comp/rajkot/n4/0281px281.x281.141004174915.w9n4/catalogue/saurashtra-gramin-bank-150-feet-ring-road-rajkot-regional-rural-banks-czu3jndeak.jpg",
										"bankName": "Saurashtra gramin bank",
										"reserved": "1"
									  },
									  {
										"bankID": 94,
										"bankLogo": "https://content.jdmagicbox.com/comp/alwar/dc/9999p1494.1494.090911110546.u7v2dc/catalogue/baroda-rajasthan-kshetriya-gramin-bank-regional-office-alwar-ho-alwar-regional-rural-banks-3258jea.jpg",
										"bankName": "Baroda Rajasthan kshetriya gramin bank",
										"reserved": "1"
									  },
									  {
										"bankID": 95,
										"bankLogo": "https://play-lh.googleusercontent.com/uWrCHBnOPyn7fejkRwHHKHHYUMkWUNk7SiV6IRy2DzXip6XPT2VUvQvaUnIjfoDKGCc",
										"bankName": "Suco Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 96,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ5InQkkIpVg3lGwhkZxeL-2ihQjjAZ66vUeA&s",
										"bankName": "Jana small finance bank",
										"reserved": "1"
									  },
									  
									  {
										"bankID": 98,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSfui7cJR-z4Uf6M2I9s4yQUIBxGEv3PcwO4g&s",
										"bankName": "Dena Gujarat Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 99,
										"bankLogo": "https://images.crunchbase.com/image/upload/c_pad,f_auto,q_auto:eco,dpr_1/ozlgbezyxnno82yan5e6?ik-sanitizeSvg=true",
										"bankName": "Chaitanya Godavari Grameena Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 100,
										"bankLogo": "https://yt3.googleusercontent.com/ytc/AIdro_nhLYyf_7Oq9FdKVe02fmEmY6nHEPsUdEtZSzWD6jP9UO0=s900-c-k-c0x00ffffff-no-rj",
										"bankName": "SVC BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 101,
										"bankLogo": "https://static.ambitionbox.com/assets/v2/images/rs:fit:200:200:false:false/bG9jYWw6Ly8vbG9nb3Mvb3JpZ2luYWxzL2JoYXJhdC1jb29wZXJhdGl2ZS1iYW5rLmpwZw.webp",
										"bankName": "Bharat cooperative bank",
										"reserved": "1"
									  },
									  {
										"bankID": 102,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQJSzd7hkZ_Sop8EsnVhB7twk_rjwpoPtd5gw&s",
										"bankName": "The Surat District Co-Op. Bank Ltd.",
										"reserved": "1"
									  },
									  {
										"bankID": 103,
										"bankLogo": "https://s2.coinmarketcap.com/static/img/coins/200x200/825.png",
										"bankName": "USDT",
										"reserved": "1"
									  },
									  {
										"bankID": 104,
										"bankLogo": "https://play-lh.googleusercontent.com/_lWXo21e0Fjcdu1Eb5VDf7hRu2a_JAsSedvQA1ii3AyDmX_H1l3rhkvp04Qa-AcXzb0",
										"bankName": "The Kalupur Commercial Co-operative Bank",
										"reserved": "1"
									  },
									 
									  {
										"bankID": 106,
										"bankLogo": "https://images.jdmagicbox.com/comp/vadodara/17/0265p265std2010017/catalogue/prime-co-op-bank-ltd-dandia-bazar-vadodara-banks-b3ury3.jpg",
										"bankName": "Prime co-operative Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 107,
										"bankLogo": "https://play-lh.googleusercontent.com/w6qzYHwG97cSfqgLInDH4STD4fG_G5L6yxJt_bylbfZ1l2dGaOVW-0IoP8-qMFD_usQ",
										"bankName": "Tripura Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 108,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTlHITXtnVzv7HK5rOR_IKlZZLeuHMjvZXKqQ&s",
										"bankName": "Zila Sahakari Bank Ltd Bareilly",
										"reserved": "1"
									  },
									  {
										"bankID": 109,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C4D0BAQF8ypO_F262Ow/company-logo_200_200/company-logo_200_200/0/1676648680097?e=2147483647&v=beta&t=qGh1bw2xDh4dnlWJ9jtIAty77YlyT_l5zP5nvb0yJGI",
										"bankName": "ARYAVART Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 110,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSTc587Ni3kdF7m1497rw1Q_QaHXxzKRl2j4w&s",
										"bankName": "Development credit Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 111,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQbpUf3gz7E9iaLm9LNs-xUn7fyTg6aIbURmQ&s",
										"bankName": "Ujjivan Small Finance Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 112,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR6jcKMxX1FH3qebnMxvCFcd8Kd9yiZEfmhRQ&s",
										"bankName": "Sarva UP Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 113,
										"bankLogo": "https://images.jdmagicbox.com/v2/mumbai/37/022p9005937/catalogue/new-india-co-operative-bank-ltd-malad-west-mumbai-cooperative-banks-d3xaf.jpg",
										"bankName": "New India Co-Operative Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 114,
										"bankLogo": "https://content3.jdmagicbox.com/v2/comp/mumbai/h6/022p1237509568s9w1h6/catalogue/nkgsb-co-operative-bank-ltd-girgaon-mumbai-cooperative-banks-4l1c0g9.jpg",
										"bankName": "NKGSB Co-operative Bank Ltd.",
										"reserved": "1"
									  },
									  {
										"bankID": 115,
										"bankLogo": "https://upload.wikimedia.org/wikipedia/en/7/70/Vijaya_Bank.svg",
										"bankName": "Vijaya Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 116,
										"bankLogo": "https://upload.wikimedia.org/wikipedia/en/c/cb/United_Bank_of_India_Logo.svg",
										"bankName": "United Bank of India",
										"reserved": "1"
									  },
									  {
										"bankID": 117,
										"bankLogo": "https://content.jdmagicbox.com/comp/kolkata/74/033p6174/catalogue/state-bank-of-bikaner-and-jaipur-kolkata-banks-g4lfa.jpg",
										"bankName": "State Bank of Bikaner And Jaipur",
										"reserved": "1"
									  },
									  {
										"bankID": 118,
										"bankLogo": "https://play-lh.googleusercontent.com/wfjAxVwqjiJwiUE4juGuzHmwBWpvXCYk638ZE-CkCiRyYv1gCpFdDddiGcbcXLGyCQ",
										"bankName": "Shri Janata Sahakari Bank LTD",
										"reserved": "1"
									  },
									  {
										"bankID": 119,
										"bankLogo": "https://play-lh.googleusercontent.com/P3V7_zIQoQq5jP0j4Fkubw5Md30rfuVxN16qzI3tXcpRn8doa6uGp817TtUHYz1Tei8",
										"bankName": "Rajgurunagar Sahakari Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 120,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRmC0bCHFuloSOLJZapHAehieEjFJDVMhGW1A&s",
										"bankName": "FEDERAL NEO BANK JUPITER",
										"reserved": "1"
									  },
									  {
										"bankID": 121,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTyiRBtY9ukUx4FkLqNc5l-FldN5j2QsrxJuQ&s",
										"bankName": "CHHATTISGARH RAJYA GRAMIN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 122,
										"bankLogo": "https://play-lh.googleusercontent.com/NjXj549oET3F_64f6bXJLL3GJSjtWT6oUNVkeWSx7f39VWV4FT_L-zcF5apgR1c0PQ",
										"bankName": "Apna Sahakari Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 123,
										"bankLogo": "https://play-lh.googleusercontent.com/EKv-jktwYVYrLOw2wXNZr6TW5V9dme8kaMFRXhgdvESDnUYasim_hugPQ9grZC7HQfkS",
										"bankName": "GS Mahanagar Co-Op Bank Ltd",
										"reserved": "1"
									  },
									  {
										"bankID": 124,
										"bankLogo": "https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEhlIzZ7Ko9vQ3j84gxIQ-UrbFJhsRChYka_eNfToMgi0kPsoYobPRrDbne4kCds0X_Tms0PEKbu9s2udcGNaBJNpL2tYzDMsku8sZ3_GxAC1mtxh-jerMIiyV7CN3iFuI9J-1se4sxC3pA/w1200-h630-p-k-no-nu/bgvb.jpg",
										"bankName": "Bangiya Gramin Vikash Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 125,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C510BAQENueu2kxK-MQ/company-logo_200_200/company-logo_200_200/0/1631361815949?e=2147483647&v=beta&t=B9dWCQ1iPjxqxFA3Q0fRBWXSLYPz2HAdG1p-qGaiFY0",
										"bankName": "Assam Gramin Vikash Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 126,
										"bankLogo": "https://content3.jdmagicbox.com/v2/comp/rajkot/n4/0281px281.x281.141004174915.w9n4/catalogue/saurashtra-gramin-bank-150-feet-ring-road-rajkot-regional-rural-banks-czu3jndeak.jpg",
										"bankName": "Saurashtra Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 127,
										"bankLogo": "https://www.legalfintax.com/storage/ifsc_logos/79.png",
										"bankName": "Kangra Central Co-operative Bank Ltd",
										"reserved": "1"
									  },
									  {
										"bankID": 128,
										"bankLogo": "https://pgb.bank.in/wp-content/uploads/2025/11/logo.png",
										"bankName": "Punjab Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 129,
										"bankLogo": "https://pbs.twimg.com/profile_images/1245223992392212481/cnrZnCSq_400x400.jpg",
										"bankName": "Assam gramin bikash bank",
										"reserved": "1"
									  },
									  {
										"bankID": 130,
										"bankLogo": "https://play-lh.googleusercontent.com/9dLuvwC7YB7AoZgJ-0czBpsqsk9jN-eS9lVoaMYfiRpLLH4UTahI22WyhbKBvXgFsw=w240-h480-rw",
										"bankName": "Karnataka Gramin Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 131,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSCfMCPCtjhNcPrYPCwTIV2K_zXYUJi5h_2rg&s",
										"bankName": "SURYODAY SMALL FINANCE BANK LIMITED",
										"reserved": "1"
									  },
									  {
										"bankID": 132,
										"bankLogo": "https://media.assettype.com/barandbench%2F2025-11-03%2Fpmih6r97%2F19.jpg",
										"bankName": "Utkarsh Small Finance Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 133,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQRhQFSnro0ZaohbhdF-pk0f5v432O5PIF8fg&s",
										"bankName": "The Meghalaya Co-operative Apex Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 134,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTNI9pmoXTUY5XkqjgedABA3xrLVVFc7Y0lUA&s",
										"bankName": "UTTAR BIHAR GRAMIN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 135,
										"bankLogo": "https://www.thebusinessquiz.com/wp-content/uploads/2014/11/SBT-Logo.png",
										"bankName": "STATE BANK OF TRAVANCORE",
										"reserved": "1"
									  },
									  {
										"bankID": 136,
										"bankLogo": "https://images.yourstory.com/cs/images/companies/Shivalik-1667996157845.jpg?fm=auto&ar=1:1&mode=fill&fill=solid&fill-color=fff",
										"bankName": "SHIVALIK SMALL FIHANCE BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 137,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQgwkpi9rjDzW98KjFbzO1Mq-KR-Lcnw4rW_w&s",
										"bankName": "DAKSHIN BIHIR GRAMIN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 138,
										"bankLogo": "https://ibsintelligence.com/wp-content/uploads/2021/09/DBS-bank-1.jpg",
										"bankName": "DBS Bank",
										"reserved": "1"
									  },
									  
									  {
										"bankID": 140,
										"bankLogo": "https://play-lh.googleusercontent.com/2NAT6HkaWsh0slQwCHPHKb5yyhqS-EFAX2n_A_QB8Y8SLqM9RD6RX-rDpkdbd1UMUa4",
										"bankName": "manipur rural bank",
										"reserved": "1"
									  },
									  {
										"bankID": 141,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTD5DppduwyYx56ZKmOG8aZn0CDt7N1SR_AMQ&s",
										"bankName": "State bank of patiala",
										"reserved": "1"
									  },
									  {
										"bankID": 142,
										"bankLogo": "https://static.wikia.nocookie.net/logopedia/images/a/a4/BGGB.jpeg/revision/latest?cb=20200407064229",
										"bankName": "BARODA GUJARAT GRAMIN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 143,
										"bankLogo": "https://is1-ssl.mzstatic.com/image/thumb/Purple211/v4/ee/c8/84/eec884ac-ff64-4056-1196-d36373ed3ac6/AppIconGSCB-0-0-1x_U007ephone-0-1-0-sRGB-85-220.png/1200x630wa.png",
										"bankName": "The Gujarat State Co-operative Bank Limited",
										"reserved": "1"
									  },
									  {
										"bankID": 144,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSmivr-jffa66fUdDhCaLLL7uthrnZOcdQ-Ag&s",
										"bankName": "vasai vikas sahakari",
										"reserved": "1"
									  },
									  {
										"bankID": 145,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR2wZwR4PFRAUcf4nCI2gQQqkl1-6fZkMcN3g&s",
										"bankName": "paschim banga gramin bank",
										"reserved": "1"
									  },
									  {
										"bankID": 146,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C510BAQER7RvhLIiISQ/company-logo_200_200/company-logo_200_200/0/1630614274833/pkgbank_logo?e=2147483647&v=beta&t=rjwvWdrzrguJcF0ubNE3qVoQH1xtUmu1v7dplnVI5D0",
										"bankName": "PRAGATHI KRISHNA GRAMIN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 147,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS6gT2gAwLctCT__6F4oNVqCAFQYnJsMqKv2Q&s",
										"bankName": "VISHAPATNAM co-operative bank",
										"reserved": "1"
									  },
									  {
										"bankID": 148,
										"bankLogo": "https://play-lh.googleusercontent.com/Zq68S5yyeoF_eg0y9Ny1T2sxleOBQGaKGVZg7yrFIFNbcHd_xYvLdVb5x8nIsal1RA=w240-h480-rw",
										"bankName": "Samarth Sahakari Bank Ltd",
										"reserved": "1"
									  },
									  {
										"bankID": 149,
										"bankLogo": "https://content.jdmagicbox.com/comp/cooch_behar/e1/9999p3582.3582.171224084438.f6e1/catalogue/uttarbanga-kshetriya-gramin-bank-nigamnagar-cooch-behar-banks-1024n445px.jpg",
										"bankName": "uttarbanga kshetriya gramin bank",
										"reserved": "1"
									  },
									  {
										"bankID": 150,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C4E0BAQHSCTIrNHHoug/company-logo_200_200/company-logo_200_200/0/1631303473466?e=2147483647&v=beta&t=oVHeVYBCbwmwz1VoaJ7yRCNsB5lzU7Z9FkxurIwUCDY",
										"bankName": "janata sahakari bank ltd",
										"reserved": "1"
									  },
									  {
										"bankID": 152,
										"bankLogo": "https://play-lh.googleusercontent.com/e7NXOSNsrQtHFO5v526_Luqyj8lHH1v5DQijeQ62CRScUlJoNrzssjH5A1PDTWxE2mJw",
										"bankName": "the gayatri co-operative urban bank",
										"reserved": "1"
									  },
									  
									  {
										"bankID": 154,
										"bankLogo": "https://play-lh.googleusercontent.com/uoc7m4EK68k5gdBMukSP96zCFz2vrkTKxftF1thq25A7ZHXmRouzPdT7yvRUJmf9Tcft",
										"bankName": "ABHYUDAYA CO-OP. BANK LTD.",
										"reserved": "1"
									  },
									 
									  {
										"bankID": 157,
										"bankLogo": "https://media.licdn.com/dms/image/v2/C510BAQGRIR1-CyK7vA/company-logo_200_200/company-logo_200_200/0/1630569120517/sbmbankindia_logo?e=2147483647&v=beta&t=9CNw9Zf5wlcXH8kXXVieggtb8z0r598cxqsvS8ht0To",
										"bankName": "SBM Bank India",
										"reserved": "1"
									  },
									  
									  {
										"bankID": 158,
										"bankLogo": "https://d1hbpr09pwz0sk.cloudfront.net/logo_url/daman-islamic-bank-39b8a85d",
										"bankName": "DAMAN",
										"reserved": "1"
									  },
									  {
										"bankID": 159,
										"bankLogo": "https://play-lh.googleusercontent.com/YPqcHl6WAU3ftTPl_KV3ifnQH5wgLFw_xm4YdlPYxAAjHsWgyq9Bpx5HR8XWCr9VVnU",
										"bankName": "Jind central Co-OP Bank",
										"reserved": "1"
									  },
									 
									  {
										"bankID": 160,
										"bankLogo": "https://play-lh.googleusercontent.com/GIwgDgYH5wKX1B0q6Jik4HiaZWMnmeIb0MojXX46iaSw5nt-MDfz5CGTwjhgLG5GmCE",
										"bankName": "The Jalgaon Peoples Co-Op Bank",
										"reserved": "1"
									  },
									  {
										"bankID": 161,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTXhApKyXb4WWjahmsOg0Wg1jD4AuaHArCHnw&s",
										"bankName": "Associated Co-operative Bank limited",
										"reserved": "1"
									  },
									  {
										"bankID": 162,
										"bankLogo": "https://play-lh.googleusercontent.com/jV6bY1o3n99mDvRXcHjCbcXNxKoIVwr6QIjnWbqVNySEM8bj8lPktiIja55ARZmZww",
										"bankName": "Mizoram Co-operative Apex Bank Ltd.",
										"reserved": "1"
									  },
									  {
										"bankID": 163,
										"bankLogo": "https://images.jdmagicbox.com/pune/g1/020pxx20.xx20.140116114013.e2g1/catalogue/the-muslim-co-operative-bank-ltd-head-office-raviwar-peth-pune-banks-4acs6-250.jpg",
										"bankName": "The Muslim Co-operative bank",
										"reserved": "1"
									  },
									  {
										"bankID": 164,
										"bankLogo": "https://upload.wikimedia.org/wikipedia/commons/thumb/6/6c/Prathama_UP_Gramin_Bank.jpg/250px-Prathama_UP_Gramin_Bank.jpg",
										"bankName": "PRATHAMA BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 165,
										"bankLogo": "https://cdn.prod.website-files.com/64199d190fc7afa82666d89c/6491bef36ed09ec3d648e61b_kasikorn-bank.webp",
										"bankName": "KASIKORN BANK",
										"reserved": "1"
									  },
									  {
										"bankID": 166,
										"bankLogo": "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQLu6GXC3A5yeV2RWpbNnzFM-DqiUGrVLalgQ&s",
										"bankName": "UCO BANK",
										"reserved": "1"
									  }
									]
								  },
								  "code": 0,
								  "msg": "Succeed",
								  "msgCode": 0,
								  "serviceNowTime": "$shnunc"
								}
							';				
						}
						else if($withdrawid == 3){
							echo '
								{
								  "data": {
									"banklist": [
									  {
										"bankID": 55,
										"bankLogo": "https://ossimg.bdg123456.com/BDGWin",
										"bankName": "TRC",
										"reserved": "3"
									  }
									]
								  },
								  "code": 0,
								  "msg": "Succeed",
								  "msgCode": 0,
								  "serviceNowTime": "$shnunc"
								}
							';	
						}
					}
					else{
						$res['code'] = 4;
						$res['msg'] = 'No operation permission';
						$res['msgCode'] = 2;
						http_response_code(401);
						echo json_encode($res);
					}					
				}
				else{					
					$res['code'] = 4;
					$res['msg'] = 'No operation permission';
					$res['msgCode'] = 2;
					http_response_code(401);
					echo json_encode($res);					
				}
			}
			else{
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);				
			}
		}
		else{
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);			
		}		
	} else {		
		http_response_code(405);
		echo json_encode($res);
	}
?>